import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:crystal_lamp', {
        onTick({ block }) {
            const state0 = block.permutation.withState('v360:light', 0)
            const state1 = block.permutation.withState('v360:light', 1)
            const state2 = block.permutation.withState('v360:light', 2)
            const state3 = block.permutation.withState('v360:light', 3)
            const state4 = block.permutation.withState('v360:light', 4)
            if (block.hasTag('v360:lamp_should_dim') && block.hasTag('v360:crystal_lamp4')) {
                block.setPermutation(state1)
            }
            else if (block.hasTag('v360:lamp_should_dim') && block.hasTag('v360:crystal_lamp3')) {
                block.setPermutation(state2)
            }
            else if (block.hasTag('v360:lamp_should_dim') && block.hasTag('v360:crystal_lamp2')) {
                block.setPermutation(state3)
            }
            else if (block.hasTag('v360:lamp_should_dim') && block.hasTag('v360:crystal_lamp1')) {
                block.setPermutation(state4)
            }
        },
        onPlayerInteract({ block, player }) {
            const state0 = block.permutation.withState('v360:light', 0)
            const state1 = block.permutation.withState('v360:light', 1)
            const state2 = block.permutation.withState('v360:light', 2)
            const state3 = block.permutation.withState('v360:light', 3)
            const state4 = block.permutation.withState('v360:light', 4)
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            const shouldNotDim = block.permutation.withState('v360:should_dim', false)
            if (selectedItem?.typeId === undefined) {
                if (block.hasTag('v360:lamp_should_dim') && block.hasTag('v360:crystal_lamp0')) {
                    block.setPermutation(state3)
                }
                else if (block.hasTag('v360:lamp_should_dim') && block.hasTag('v360:crystal_lamp1')) {
                    block.setPermutation(state2)
                }
                else if (block.hasTag('v360:lamp_should_dim') && block.hasTag('v360:crystal_lamp2')) {
                    block.setPermutation(state1)
                }
                else if (block.hasTag('v360:lamp_should_dim') && block.hasTag('v360:crystal_lamp3')) {
                    block.setPermutation(state0)
                }
            }
            else if (selectedItem?.typeId === 'minecraft:amethyst_shard' && block.hasTag('v360:lamp_should_dim') && block.typeId === 'v360:amethyst_lamp') {
                block.setPermutation(shouldNotDim)
                block.dimension.playSound('block.copper_bulb.turn_on', block.location)
                if (player.getGameMode() !== 'creative') {
                    player.runCommand(`clear @s minecraft:amethyst_shard 0 1`)
                }
            }
            else if (selectedItem?.typeId === 'v360:citrine_shard' && block.hasTag('v360:lamp_should_dim') && block.typeId === 'v360:citrine_lamp') {
                block.setPermutation(shouldNotDim)
                block.dimension.playSound('block.copper_bulb.turn_on', block.location)
                if (player.getGameMode() !== 'creative') {
                    player.runCommand(`clear @s v360:citrine_shard 0 1`)
                }
            }
            else if (selectedItem?.typeId === 'v360:garnet_shard' && block.hasTag('v360:lamp_should_dim') && block.typeId === 'v360:garnet_lamp') {
                block.setPermutation(shouldNotDim)
                block.dimension.playSound('block.copper_bulb.turn_on', block.location)
                if (player.getGameMode() !== 'creative') {
                    player.runCommand(`clear @s v360:garnet_shard 0 1`)
                }
            }
            else if (selectedItem?.typeId === 'v360:jade_shard' && block.hasTag('v360:lamp_should_dim') && block.typeId === 'v360:jade_lamp') {
                block.setPermutation(shouldNotDim)
                block.dimension.playSound('block.copper_bulb.turn_on', block.location)
                if (player.getGameMode() !== 'creative') {
                    player.runCommand(`clear @s v360:jade_shard 0 1`)
                }
            }
        },
        onPlace({ block }) {
            const shouldDim = block.permutation.withState('v360:should_dim', true)
            block.setPermutation(shouldDim)
        }
    })
})